/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.dimension.client.RFToolsDimensionSpecialEffects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ClientDimensionData {
    private static final ClientDimensionData INSTANCE = new ClientDimensionData();
    private Map<ResourceLocation, ClientData> clientDataMap = new HashMap<ResourceLocation, ClientData>();
    private long worldSeed = -1L;

    public static ClientDimensionData get() {
        return INSTANCE;
    }

    public long getPower(ResourceLocation id) {
        return this.clientDataMap.getOrDefault((Object)id, (ClientData)ClientData.NONE).power;
    }

    public long getMaxPower(ResourceLocation id) {
        return this.clientDataMap.getOrDefault((Object)id, (ClientData)ClientData.NONE).max;
    }

    @Nonnull
    public ClientData getClientData(ResourceLocation id) {
        return this.clientDataMap.getOrDefault(id, ClientData.NONE);
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public void updateDataFromServer(Map<ResourceLocation, ClientData> clientDataMap, long seed) {
        this.clientDataMap = clientDataMap;
        this.worldSeed = seed;
        RFToolsDimensionSpecialEffects.clearCache();
    }

    public void clear() {
        this.worldSeed = -1L;
        this.clientDataMap.clear();
    }

    public record ClientData(long power, long max, long skyDimletTypes) {
        public static final ClientData NONE = new ClientData(-1L, -1L, 0L);

        public static ClientData create(FriendlyByteBuf buf) {
            long power = buf.readLong();
            long max = buf.readLong();
            long skyDimletTypes = buf.readLong();
            return new ClientData(power, max, skyDimletTypes);
        }

        public void writeToBuf(FriendlyByteBuf buf) {
            buf.writeLong(this.power);
            buf.writeLong(this.max);
            buf.writeLong(this.skyDimletTypes);
        }
    }
}

